//
//  BIAppliedTax.h
//  BISubstrate
//
//  Created by Eric Hochmeister on 14/09/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

/*!
    @class       BIAppliedTax
    @abstract    BIAppliedTax is a non-persistent tax whose purpose is soley as a wrapper to display what taxes are applied and their associated amounts.
    @discussion  This is used for reporting, so that getting this data in a report is easier. Just use keypaths and to make displaying this information easier and more accessible to the user.
*/


#import <Cocoa/Cocoa.h>

@class BITax;

@interface BIAppliedTax : NSObject {

    BITax* tax;
    NSNumber* total;
    
}

+ (id)appliedTaxWithTax:(BITax*)aTax total:(NSNumber*)aTotal;

- (id)initWithTax:(BITax*)aTax total:(NSNumber*)aTotal;

- (BITax *)tax;
- (void)setTax:(BITax *)value;

- (NSNumber *)total;
- (void)setTotal:(NSNumber *)value;

//- (NSNumber*)orderIndex;
//- (void)setOrderIndex:(NSNumber*)aNum;

@end
